/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls.legacy;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.searchguard.authc.legacy.LegacySgConfig;
import com.floragunn.searchguard.authz.config.AuthorizationConfig;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.license.LicenseChangeListener;
import com.floragunn.searchguard.license.SearchGuardLicense;
import com.floragunn.searchsupport.StaticSettings;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.cache.clear.ClearIndicesCacheRequest;
import org.elasticsearch.action.admin.indices.cache.clear.ClearIndicesCacheResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xcontent.ToXContent;

public class DlsFlsComplianceConfig
implements LicenseChangeListener {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final Settings settings;
    private final byte[] salt16;
    private volatile boolean enabled = true;
    private final boolean localHashingEnabled;
    private byte[] salt2_16;
    private final byte[] maskPrefix;
    private final Client client;

    public DlsFlsComplianceConfig(Settings settings, ConfigurationRepository configRepository, Client client) {
        this.settings = settings;
        this.client = client;
        this.localHashingEnabled = this.settings.getAsBoolean("searchguard.compliance.local_hashing_enabled", Boolean.valueOf(false));
        String saltAsString = settings.get("searchguard.compliance.salt", "e1ukloTsQlOgPquJ");
        byte[] saltAsBytes = saltAsString.getBytes(StandardCharsets.UTF_8);
        if (saltAsBytes.length < 16) {
            throw new ElasticsearchException("searchguard.compliance.salt must at least contain 16 bytes", new Object[0]);
        }
        if (saltAsBytes.length > 16) {
            this.log.warn("searchguard.compliance.salt is greater than 16 bytes. Only the first 16 bytes are used for salting");
        }
        this.salt16 = Arrays.copyOf(saltAsBytes, 16);
        String maskPrefixString = settings.get("searchguard.compliance.mask_prefix", null);
        this.maskPrefix = (byte[])(maskPrefixString == null || maskPrefixString.isEmpty() ? null : maskPrefixString.getBytes(StandardCharsets.UTF_8));
        configRepository.subscribeOnChange(configMap -> {
            SgDynamicConfiguration config = configMap.get(CType.AUTHZ);
            SgDynamicConfiguration legacyConfig = configMap.get(CType.CONFIG);
            if (config != null && config.getCEntry("default") != null) {
                AuthorizationConfig authzConfig = (AuthorizationConfig)config.getCEntry("default");
                this.setFieldAnonymizationSalt2(authzConfig.getFieldAnonymizationSalt());
                this.log.info("Updated authz config:\n" + config);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)authzConfig);
                }
            } else if (legacyConfig != null && legacyConfig.getCEntry("sg_config") != null) {
                try {
                    LegacySgConfig sgConfig = (LegacySgConfig)legacyConfig.getCEntry("sg_config");
                    AuthorizationConfig privilegesConfig = AuthorizationConfig.parseLegacySgConfig((DocNode)sgConfig.getSource(), null, (StaticSettings)new StaticSettings(settings, null));
                    this.setFieldAnonymizationSalt2(privilegesConfig.getFieldAnonymizationSalt());
                    this.log.info("Updated authz config (legacy):\n" + legacyConfig);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)privilegesConfig);
                    }
                }
                catch (ConfigValidationException e) {
                    this.log.error("Error while parsing sg_config:\n" + (Object)((Object)e));
                }
            }
        });
    }

    public void onChange(SearchGuardLicense license) {
        this.enabled = license == null ? false : license.hasFeature(SearchGuardLicense.Feature.COMPLIANCE);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public byte[] getSalt16() {
        return (byte[])this.salt16.clone();
    }

    public boolean isLocalHashingEnabled() {
        return this.localHashingEnabled;
    }

    private void setFieldAnonymizationSalt2(String fieldAnonymizationSalt2) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("ComplianceConfiguration#onChanged called");
            this.log.trace("isLocalHashingEnabled? " + this.isLocalHashingEnabled());
            this.log.trace("FieldAnonymizationSalt2: " + fieldAnonymizationSalt2);
        }
        if (this.isLocalHashingEnabled() && fieldAnonymizationSalt2 != null) {
            String salt2AsString = fieldAnonymizationSalt2;
            if (salt2AsString != null && !salt2AsString.isEmpty()) {
                byte[] _salt2_16;
                byte[] salt2AsBytes = salt2AsString.getBytes(StandardCharsets.UTF_8);
                if (salt2AsBytes.length < 16) {
                    this.log.error("searchguard.dynamic.field_anonymization.salt2 must at least contain 16 bytes");
                }
                if (salt2AsBytes.length > 16) {
                    this.log.warn("searchguard.dynamic.field_anonymization.salt2 is greater than 16 bytes. Only the first 16 bytes are used");
                }
                if (!Arrays.equals(this.salt2_16, _salt2_16 = Arrays.copyOf(salt2AsBytes, 16))) {
                    this.log.debug("value of searchguard.dynamic.field_anonymization.salt2 changed");
                    this.salt2_16 = _salt2_16;
                    ClearIndicesCacheRequest clearIndicesCacheRequest = new ClearIndicesCacheRequest(new String[0]);
                    clearIndicesCacheRequest.fieldDataCache(false);
                    clearIndicesCacheRequest.queryCache(false);
                    clearIndicesCacheRequest.requestCache(true);
                    this.client.admin().indices().clearCache(clearIndicesCacheRequest, (ActionListener)new ActionListener<ClearIndicesCacheResponse>(){

                        public void onResponse(ClearIndicesCacheResponse response) {
                            DlsFlsComplianceConfig.this.log.debug("Cache cleared due to salt2 changed: " + Strings.toString((ToXContent)response));
                        }

                        public void onFailure(Exception e) {
                            DlsFlsComplianceConfig.this.log.debug("Cache cleared due to salt2 changed: " + e, (Throwable)e);
                        }
                    });
                }
            } else {
                this.log.error("searchguard.compliance.local_hashing_enabled is enabled but searchguard.dynamic.field_anonymization.salt2 is not set");
            }
        }
    }

    public byte[] getSalt2_16() {
        return this.salt2_16 == null ? null : (byte[])this.salt2_16.clone();
    }

    public byte[] getMaskPrefix() {
        return this.maskPrefix;
    }
}

